	subroutine SHAPEM(iout, idbg, Ne, Ng, Sx, D, &
			 Ae, Be, wg, e, Shp, dNdr, Jac, Ji)
! calculate element matrices

	implicit none
	integer iout, idbg
	integer Ne, Ng			! array parameters
	real*8 Sx
	real*8 Ae(4,4), Be(4,4)		! element arrays
	real*8 D(Ne,2,2)		! global  arrays
	real*8 wg(Ng)				! Gauss weights
	real*8 Ji(2,2,Ng,Ng), Jac(Ng,Ng)			! geometric entities
	real*8 Shp(4,Ng,Ng), dNdr(4,2,Ng,Ng)	! shape functions
	integer e

	integer g1, g2, i, p, k, q, ii, jj
	real*8 w

!	write(idbg,'(a)') ' --- SHAPEM ---'	! ### TEMPORARY ###

	Ae = 0.d0	! use matrix form
	Be = 0.d0	! use matrix form

	do g1 = 1, Ng
	  do g2 = 1, Ng
	    w = wg(g1)*wg(g2)

! calculate the mass matrix, Ae
! consistent mass matrix:
	    do ii = 1, 4
	      do jj = 1, 4
	        Ae(ii,jj) = Ae(ii,jj) + Sx * w * Shp(ii,g1,g2) * Shp(jj,g1,g2) * Jac(g1,g2)
	      enddo	! jj
	    enddo	! ii

! calculate the conduction matrix, Be
	    do i = 1,2
	      do p = 1,2
	        do k = 1,2
	          do q = 1,2
	            do ii = 1, 4
	              do jj = 1, 4
			Be(ii,jj) = Be(ii,jj) + Sx * w * dNdr(ii,k,g1,g2) * Ji(k,i,g1,g2) * &
				    D(e,i,p) * dNdr(jj,q,g1,g2) * Ji(q,p,g1,g2) * Jac(g1,g2)
	              enddo	! jj
	            enddo	! ii
	          enddo		! q
	        enddo		! k
	      enddo		! p
	    enddo		! i

	  enddo	! g2
	enddo	! g1
	
	return
	end
